<?xml version="1.0" encoding="UTF-8"?><!--
            Copyright
            2010 axYus - http://www.axyus.com
            2010 J.Leger - johann.leger@axyus.com

            This file is part of ODM print-comp.

            ODM print-comp is free software; you can redistribute it and/or modify
            it under the terms of the GNU Lesser General Public License as published by
            the Free Software Foundation; either version 2 of the License, or
            (at your option) any later version.

            ODM print-comp is distributed in the hope that it will be useful,
            but WITHOUT ANY WARRANTY; without even the implied warranty of
            MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
            GNU Lesser General Public License for more details.

            You should have received a copy of the GNU Lesser General Public License
            along with ODM print-comp; if not, write to the Free Software
            Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
        --><xsl:stylesheet xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:xad="http://uri.etsi.org/01903/v1.2.2#" xmlns:data="http://odm-budgetaire.org/data" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:date="http://exslt.org/dates-and-times" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:com="http://www.xemelios.org/namespaces#cg-1.0" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data"><xsl:import href="../../../../number.xsl"></xsl:import><xsl:import href="../../../../date.xsl"></xsl:import><xsl:import href="../../../../table.xsl"></xsl:import><xsl:import href="../../../../style.xsl"></xsl:import><xsl:import href="../../../../lien.xsl"></xsl:import><xsl:param name="HTML_OUTPUT_FORMAT"></xsl:param><xsl:param name="PDF_OUTPUT_FORMAT"></xsl:param><xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/dcfu:CompteFinancierUnique"></xsl:variable><xsl:param name="nomenclaturePasEnrichie"></xsl:param><xsl:variable name="nomenclature" select="$nomenclaturePasEnrichie/n:Nomenclature"></xsl:variable><xsl:variable name="data" select="document('../../libelleAffiche.xml')/data"></xsl:variable><xsl:variable name="isPrint" select="1"></xsl:variable><xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="*"></xsl:template><xsl:template match="dcfu:CompteFinancierUnique"><html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
   <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" /><meta name="generator" content="ODM" />
      
      <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css" />
      <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css" />
      
      <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:SimSun;
  panose-1:2 1 6 0 3 1 1 1 1 1;}
@font-face
  {font-family:Mangal;
  panose-1:0 0 4 0 0 0 0 0 0 0;}
@font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:Calibri;
  panose-1:2 15 5 2 2 2 4 3 2 4;}
@font-face
  {font-family:"\@SimSun";
  panose-1:2 1 6 0 3 1 1 1 1 1;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0cm;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
p.Contenudetableau, li.Contenudetableau, div.Contenudetableau
  {
  margin:0cm;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
@page{size:297mm 210mm;
  }
div.WordSection1
  {}
--&gt;
/**/
}</style></head>
   <body lang="FR" style="word-wrap:break-word"><div id="header">
         <xsl:variable name="varOdmTmpTab1"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none"><tr><td width="75%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p style="punctuation-wrap:simple"><span style="font-size: 10.0pt;font-family:&#34;Arial&#34;,sans-serif">
                        <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@CodeBC)"/> – 
                        
                        
                        <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Libelle)"/></span></p></td><td width="25%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="right" style="text-align:right;punctuation-wrap:simple"><span style="font-size:10.0pt;font-family:&#34;Arial&#34;,sans-serif">Exercice 
                        
                        
                        <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V)"/></span></p></td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab1"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"><span style="font-size:4.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
      </div>
      
      <div class="WordSection1">
         <xsl:variable name="varOdmTmpTab2"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none"><thead>
               <tr><td width="90%" valign="top" style="border:solid black 1.0pt; padding:2.85pt 2.85pt 2.85pt 2.85pt" rowspan="1" colspan="1">
                     <p class="MsoNormal" align="center" style="text-align:center"><xsl:variable name ="Refer7">DBILANSYNTH</xsl:variable><xsl:variable name ="Refer8" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Refer9" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="lien:reference"><xsl:with-param name="id" select="concat ($Refer7, '_', $Refer8, '_', $Refer9)"/></xsl:call-template><b>I – INFORMATIONS GÉNÉRALES ET SYNTHÉTIQUES</b></p>
                  </td><td width="10%" valign="top" style="border:solid black 1.0pt; border-left:none;padding:2.85pt 2.85pt 2.85pt 2.85pt" rowspan="1" colspan="1">
                     <p class="MsoNormal" align="center" style="text-align:center"><b>I</b></p>
                  </td></tr>
               <tr><td width="90%" valign="top" style="border:solid black 1.0pt; border-top:none;padding:2.85pt 2.85pt 2.85pt 2.85pt" rowspan="1" colspan="1">
                     <p class="MsoNormal" align="center" style="text-align:center"><b>Bilan synthétique (en milliers d'euros)</b></p>
                  </td><td width="10%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:2.85pt 2.85pt 2.85pt 2.85pt" rowspan="1" colspan="1">
                     <p class="MsoNormal" align="center" style="text-align:center"><b>D</b></p>
                  </td></tr>
               <tr style="height:15.6pt"><td width="90%" valign="top" style="border:none;padding:0cm 0cm 0cm 0cm; height:15.6pt" rowspan="1" colspan="1"> </td><td width="10%" valign="top" style="border:none;padding:0cm 0cm 0cm 0cm; height:15.6pt" rowspan="1" colspan="1"> </td></tr>
            </thead><tr><td width="100%" colspan="2" valign="top" style="border:solid black 1.0pt; border-top:none;padding:0cm 0cm 0cm 0cm" rowspan="1">
                  <xsl:variable name="varOdmTmpTab3"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none"><tr height="0" class="#tech# #fixWidths#"><td width="50%" style="border:none" rowspan="1" colspan="1"></td><td width="50%" style="border:none" rowspan="1" colspan="1"></td></tr><tr><td width="50%" valign="top" style="padding:0cm 0cm 0cm 0cm" rowspan="1" colspan="1">
                           <xsl:variable name="varOdmTmpTab4"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none"><xsl:variable name="varOdm1" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable[(./dc:Etat/@V='BI_S_A') and (./dc:ModeTraitement/@V!='NOTE_BAS_PAGE')]"/><thead>
                                 <tr style="height:15.6pt"><td width="76%" valign="top" style="border:solid black 1.0pt; border-left:none;padding: 0cm 0cm 1.5pt 0cm;height:15.6pt" rowspan="1" colspan="1">
                                       <p class="Contenudetableau"><b><span style="font-size:8.0pt">ACTIF NET (1)</span></b><span style="font-size:8.0pt"></span></p>
                                    </td><td width="24%" valign="top" style="border-top:solid black 1.0pt; border-left:none;border-bottom:solid black 1.0pt;border-right:none; padding: 0cm 0cm 1.5pt 0cm;height:15.6pt" rowspan="1" colspan="1">
                                       <p class="Contenudetableau" align="center" style="text-align:center"><b><span style="font-size:8.0pt">Total</span></b></p>
                                    </td></tr>
                              </thead><xsl:variable name="varOdm2" select="$varOdm1"/><xsl:variable name="varOdm3"><xsl:for-each select="$varOdm2"><xsl:sort select="./dc:NumOrdre/@V" data-type="number"/><xsl:variable name="ligne" select="."/><tr><xsl:variable name="content33"><xsl:value-of select="distinct-values($ligne/dc:Intitule1/@V)"/></xsl:variable><xsl:variable name="className66" select="$ligne/dc:Format/@V"/><xsl:variable name="className67">LIBELLE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className66, ' ', $className67)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">76%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content33" /></xsl:call-template><xsl:variable name="content34"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/dc:MtNet/@V"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className68" select="$ligne/dc:Format/@V"/><xsl:variable name="className69">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className68, ' ', $className69)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">24%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content34" /></xsl:call-template></tr></xsl:for-each></xsl:variable><xsl:variable name="varOdm4"><xsl:choose><xsl:when test="count($varOdm3/*) = 0"><tr class=" #tech#" style="height:15.6pt"><td height="1px" width="76%" valign="top" rowspan="1" colspan="1" style=" border-left:none;padding: 0cm 0cm 1.5pt 0cm; border-top:hidden; border-bottom:solid black 1.0pt; border-right:solid black 1.0pt"></td><td height="1px" width="24%" valign="top" rowspan="1" colspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:none; padding: 0cm 0cm 1.5pt 0cm;"></td></tr></xsl:when><xsl:otherwise><xsl:sequence select="$varOdm3"></xsl:sequence></xsl:otherwise></xsl:choose></xsl:variable><xsl:call-template name="table:processRowStyled"><xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param><xsl:with-param name="rows" select="$varOdm4/xhtml:tr"></xsl:with-param></xsl:call-template><tr><xsl:variable name="varOdm5" select="$varOdm1"/><td width="100%" colspan="2" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p style="punctuation-wrap:simple"><xsl:if test="not($docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable/dc:NumOrdre/@V and $docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable/dc:Etat/@V='BI_S_A')">Cet état ne contient pas d'information.</xsl:if></p></td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab4"></xsl:with-param></xsl:call-template>
                        </td><td width="50%" valign="top" style="padding:0cm 0cm 0cm 0cm" rowspan="1" colspan="1">
                           <xsl:variable name="varOdmTmpTab5"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none"><xsl:variable name="varOdm6" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable[(./dc:Etat/@V='BI_S_P')]"/><thead>
                                 <tr style="height:15.6pt"><td width="76%" colspan="2" valign="top" style="border:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;height:15.6pt" rowspan="1">
                                       <p class="Contenudetableau"><b><span style="font-size:8.0pt">FONDS PROPRES ET PASSIF</span></b><span style="font-size:8.0pt"></span></p>
                                    </td><td width="24%" valign="top" style="border-top:solid black 1.0pt; border-left:none;border-bottom:solid black 1.0pt;border-right:none; padding: 0cm 0cm 1.5pt 0cm;height:15.6pt" rowspan="1" colspan="1">
                                       <p class="Contenudetableau" align="center" style="text-align:center"><b><span style="font-size:8.0pt">Total</span></b></p>
                                    </td></tr>
                              </thead><xsl:variable name="varOdm7" select="$varOdm6"/><xsl:variable name="varOdm8"><xsl:for-each select="$varOdm7"><xsl:sort select="./dc:NumOrdre/@V" data-type="number"/><xsl:variable name="ligne" select="."/><tr><xsl:variable name="content35"><xsl:value-of select="distinct-values($ligne/dc:Intitule1/@V)"/></xsl:variable><xsl:variable name="className70" select="$ligne/dc:Format/@V"/><xsl:variable name="className71">LIBELLE</xsl:variable><xsl:variable name="className72">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className70, ' ', $className71, ' ', $className72)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">2</xsl:with-param><xsl:with-param name="width">76%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content35" /></xsl:call-template><xsl:variable name="content36"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/dc:MtNet/@V"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className73" select="$ligne/dc:Format/@V"/><xsl:variable name="className74">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className73, ' ', $className74)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">24%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content36" /></xsl:call-template></tr></xsl:for-each></xsl:variable><xsl:variable name="varOdm9"><xsl:choose><xsl:when test="count($varOdm8/*) = 0"><tr class=" #tech#" style="height:15.6pt"><td height="1px" width="76%" colspan="2" valign="top" rowspan="1" style=" padding: 0cm 0cm 1.5pt 0cm; border-top:hidden; border-bottom:solid black 1.0pt; border-left:solid black 1.0pt; border-right:solid black 1.0pt"></td><td height="1px" width="24%" valign="top" rowspan="1" colspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:none; padding: 0cm 0cm 1.5pt 0cm;"></td></tr></xsl:when><xsl:otherwise><xsl:sequence select="$varOdm8"></xsl:sequence></xsl:otherwise></xsl:choose></xsl:variable><xsl:call-template name="table:processRowStyled"><xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param><xsl:with-param name="rows" select="$varOdm9/xhtml:tr"></xsl:with-param></xsl:call-template><tr><xsl:variable name="varOdm10" select="$varOdm6"/><td width="1%" style="border:none;padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                                    <p class="MsoNormal"> </p>
                                 </td><td width="76%" colspan="2" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p style="punctuation-wrap:simple"><xsl:if test="not($docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable/dc:NumOrdre/@V and $docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable/dc:Etat/@V='BI_S_P')">Cet état ne contient pas d'information.</xsl:if></p></td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab5"></xsl:with-param></xsl:call-template>
                        </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab3"></xsl:with-param></xsl:call-template>
               </td></tr><tr><td width="100%" colspan="2" valign="top" style="border:none; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1">
                  <p class="MsoNormal"><span style="font-size:8.0pt"> </span></p>
                  <xsl:variable name="varOdmTmpTab6"><table width="100%" class="MsoNormalTable " border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse"><xsl:variable name="varOdm11" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable[(./dc:ModeTraitement/@V='NOTE_BAS_PAGE') and (./dc:Etat/@V='BI_S_A')]"/><tr><td width="100%" valign="top" style="padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                           <p class="MsoNormal" style="line-height:115%;layout-grid-mode:char; punctuation-wrap:simple"><span style="font-size:6.0pt;line-height:115%"></span></p>
                        </td></tr><xsl:variable name="varOdm12" select="$varOdm11"/><xsl:variable name="varOdm13"><xsl:for-each select="$varOdm12"><xsl:sort select="./dc:NumOrdre/@V" data-type="number"/><xsl:variable name="ligne" select="."/><tr><xsl:variable name="content37"><xsl:value-of select="distinct-values($ligne/dc:NoteBasTableau/@V)"/></xsl:variable><xsl:variable name="className75" select="$ligne/dc:Format/@V"/><xsl:variable name="className76">FONT6</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className75, ' ', $className76)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">100%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content37" /></xsl:call-template></tr></xsl:for-each></xsl:variable><xsl:variable name="varOdm14"><xsl:choose><xsl:when test="count($varOdm13/*) = 0"><tr class=" #tech#"><td height="1px" width="100%" valign="top" rowspan="1" colspan="1" style="padding:2.75pt 2.75pt 2.75pt 2.75pt"></td></tr></xsl:when><xsl:otherwise><xsl:sequence select="$varOdm13"></xsl:sequence></xsl:otherwise></xsl:choose></xsl:variable><xsl:call-template name="table:processRowStyled"><xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param><xsl:with-param name="rows" select="$varOdm14/xhtml:tr"></xsl:with-param></xsl:call-template></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab6"></xsl:with-param></xsl:call-template>
               </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab2"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"><span style="font-size:4.0pt"> </span></p>
      </div>
   </body><script type="text/javascript">
            function iframeLoadPage(href) {
            try {
            parent.loadPage(href);
            } catch(ex) {
            //si on n'arrive pas a acceder a la page parente
            document.location.href = href;
            }
            }
            function scrollToElementId(elementId) {
            document.getElementById(elementId).scrollIntoView();
            }
        </script>
</html></xsl:template></xsl:stylesheet>